/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright 
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.va.rxnorm.rrf;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * {@link RXNSAT}
 *
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a> 
 */
public class RXNSAT
{
	public String rxcui, rxaui, stype, code, atui, satui, atn, sab, atv, suppress, cvf;
	
	public RXNSAT(ResultSet rs) throws SQLException
	{
		rxcui = rs.getString("RXCUI");
		rxaui = rs.getString("RXAUI");
		stype = rs.getString("STYPE");
		code = rs.getString("CODE");
		atui = rs.getString("ATUI");
		satui = rs.getString("SATUI");
		atn = rs.getString("ATN");
		sab = rs.getString("SAB");
		atv = rs.getString("ATV");
		suppress = rs.getString("SUPPRESS");
		cvf = rs.getString("CVF");
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "RXNSAT [rxcui=" + rxcui + ", rxaui=" + rxaui + ", stype=" + stype + ", code=" + code + ", atui=" + atui
				+ ", satui=" + satui + ", atn=" + atn + ", sab=" + sab + ", atv=" + atv + ", suppress=" + suppress
				+ ", cvf=" + cvf + "]";
	}
}
